﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;

namespace VeteransAffairs.Registries.BusinessAHOBPR
{
    public partial class REGISTRANT_SERVICE_EPISODE : IComparable<REGISTRANT_SERVICE_EPISODE>, IEquatable<REGISTRANT_SERVICE_EPISODE>
    {

        private DateTime ComparableEndDate
        {
            get
            {
                if (this.SERVICE_EPISODE_END_DATE.HasValue && (this.SERVICE_EPISODE_END_DATE != DateTime.Parse("0001-01-01")))
                {
                    return this.SERVICE_EPISODE_END_DATE.Value;
                }
                return DateTime.Parse("9999-11-11"); 
            }
        }

        private DateTime ComparableStartDate
        {
            get
            {
                if (this._SERVICE_EPISODE_START_DATE.HasValue)
                {
                    return this._SERVICE_EPISODE_START_DATE.Value;
                }
                return new DateTime(1900, 1, 1);
            }
        }

        public int CompareTo(REGISTRANT_SERVICE_EPISODE other)
        {
            int endDateComparison = this.ComparableEndDate.CompareTo(other.ComparableEndDate);
            if (endDateComparison == 0)
            {
                int startDateComparison = this.ComparableStartDate.CompareTo(other.ComparableStartDate);
                if (startDateComparison == 0)
                {
                    return -1 * this.CREATED.CompareTo(other.CREATED);
                }
                return startDateComparison * -1;
            }
            return endDateComparison * -1;
        }

        public bool Equals(REGISTRANT_SERVICE_EPISODE other)
        {
            if (other == null)
                return false;
            //Console.WriteLine($"{this.STD_BRANCH_OF_SERVICE} and {other.STD_BRANCH_OF_SERVICE}");
            return this.REGISTRANT_ID.Equals(other.REGISTRANT_ID) &&
                (
                 this.STD_BRANCH_OF_SERVICE_ID == other.STD_BRANCH_OF_SERVICE_ID
                ) &&
                (
                 this.STD_BRANCH_OF_SERVICE == other.STD_BRANCH_OF_SERVICE
                ) &&
                (
                 this.PERSONNEL_CATEGORY_TYPE_CODE == other.PERSONNEL_CATEGORY_TYPE_CODE
                ) &&
                (
                 this.ComparableStartDate == other.ComparableStartDate
                ) &&
                (
                 this.ComparableEndDate == other.ComparableEndDate
                ) &&
                (
                 this.SERVICE_EPISODE_TERMINATION_REASON == other.SERVICE_EPISODE_TERMINATION_REASON
                ) &&
                (
                 this.SERVICE_EPISODE_TERMINATION_REASON == other.SERVICE_EPISODE_TERMINATION_REASON
                ) &&
                (
                 this.BRANCH_OF_SERVICE_TEXT == other.BRANCH_OF_SERVICE_TEXT
                ) &&
                (
                 this.NARRATIVE_REASON_FOR_SEPARATION_TEXT == other.NARRATIVE_REASON_FOR_SEPARATION_TEXT
                );
        }

        public bool HasSameStartAndEndDate(REGISTRANT_SERVICE_EPISODE other)
        {
            if (other == null)
                return false;

            return (this.ComparableStartDate == other.ComparableStartDate
                ) &&
                (
                 this.ComparableEndDate == other.ComparableEndDate
                );
        }
        public void Update(REGISTRANT_SERVICE_EPISODE other)
        {
            this.SetAsChangeTrackingRoot();
            this.PERSONNEL_CATEGORY_TYPE_CODE = other.PERSONNEL_CATEGORY_TYPE_CODE;
            this.SERVICE_EPISODE_START_DATE = other.SERVICE_EPISODE_START_DATE;
            if (other.SERVICE_EPISODE_END_DATE != DateTime.Parse("0001-01-01")){
                this.SERVICE_EPISODE_END_DATE = other.SERVICE_EPISODE_END_DATE;
            }
            this.SERVICE_EPISODE_TERMINATION_REASON = other.SERVICE_EPISODE_TERMINATION_REASON;
            this.SERVICE_EPISODE_TERMINATION_REASON = other.SERVICE_EPISODE_TERMINATION_REASON;
            this.BRANCH_OF_SERVICE_TEXT = other.BRANCH_OF_SERVICE_TEXT;
            this.NARRATIVE_REASON_FOR_SEPARATION_TEXT = other.NARRATIVE_REASON_FOR_SEPARATION_TEXT;
            this.UPDATED = DateTime.UtcNow;
            this.UPDATEDBY = "MilitaryServiceEpisodeImporter";
            this.SetAsUpdateOnSubmit();
        }
        public static bool operator <(REGISTRANT_SERVICE_EPISODE rse1, REGISTRANT_SERVICE_EPISODE rse2)
        {
            return rse1.CompareTo(rse2) < 0;
        }

        public static bool operator >(REGISTRANT_SERVICE_EPISODE rse1, REGISTRANT_SERVICE_EPISODE rse2)
        {
            return rse1.CompareTo(rse2) > 0;
        }
    }
}
